******************************************************
* ADCTEST.SRC                                        *
*                                                    *
* This program reads the ADC0804 attached to Port B  *
* of the 6821 and reports the result on the console  *
* as a hexadecimal byte.                             *
******************************************************
PIA      EQU      $10001        ;base address of 6821
PORTB    EQU      2*2           ;6821 Port B
CRB      EQU      3*2           ;Data Direction Reg.
CR       EQU      $0D           ;ASCII carriage ret.
LF       EQU      $0A           ;ACII line feed
OUT2HX   EQU      $000B14       ;MON68K (V4.4)

         ORG      $8000
ADCTEST  MOVEA.L  #BANNER,A1    ;A1 -> message
         TRAP     #2            ;send it
         MOVEA.L  #PIA,A0       ;A0 -> 6821 PIA
         MOVE.B   #$3C,CRB(A0)  ;initialize CB2 = 1
REPEAT   MOVE.B   #$34,CRB(A0)  ;start conversion by
         MOVE.B   #$3C,CRB(A0)  ; toggling CB2 (-WR)
AGAIN    BTST.B   #7,CRB(A0)    ;IRQB flag set? (-INTR)
         BEQ      AGAIN         ;no:  check again
         MOVE.B   PORTB(A0),D0  ;yes: get ADC0804 data
         JSR      OUT2HX        ;send it to console
         MOVE.B   #CR,D0        ;send CR too, to
         TRAP     #1            ; prepare for next
         BRA      REPEAT        ; conversion

BANNER   DC.B     CR,LF
         DC.B     '*** TEST ADC0804 ***',CR,LF,0
         END      ADCTEST
